//---------------------------------------------------------------------------
// Description:
//
//   Blends both diffuse colors to obtain the current diffuse color.
//
// Input:
//
//   EAX  -  Alpha (A8R8G8B8 value)
//
// Output:
//
//   MM4  -  Diffuse Color (unpacked)
//
// Registers Used:
//
//   EAX, MM0, MM2, MM3, MM4, MM5, MM7
//---------------------------------------------------------------------------

// -------------------------------------------------------
// 1. Load Alpha to MM2
// -------------------------------------------------------
{ movd      mm2, eax
 punpcklbw mm2, mm7

// -------------------------------------------------------
// 2. Load Inverse Alpha to MM2
// -------------------------------------------------------
 mov       ecx, 0FFFFFFFFh
 movd      mm3, ecx
 punpcklbw mm3, mm7
 psubsw    mm3, mm2
 
// -------------------------------------------------------
// 3. Load Diffuse1 to MM0
// -------------------------------------------------------
 movq      mm0, mm5
 punpcklbw mm0, mm7

// -------------------------------------------------------
// 3. Load Diffuse2 to MM4
// -------------------------------------------------------
 movq      mm4, mm5
 psrlq     mm4, 32
 punpcklbw mm4, mm7

// -------------------------------------------------------
// 4. Multiply diffuse colors by alpha values
// -------------------------------------------------------
 pmullw mm0, mm3
 pmullw mm4, mm2

// -------------------------------------------------------
// 5. Divide diffuse colors by 256
// -------------------------------------------------------
 psrlw mm0, 8
 psrlw mm4, 8

// -------------------------------------------------------
// 6. Add diffuse colors by 256
// -------------------------------------------------------
 paddw mm4, mm0}

 // -------------------------------------------------------
 // B. load Diffuse Alpha to MM3 register, unpacked
 // -------------------------------------------------------
 movd      mm3, eax
 punpcklbw mm3, mm7

 // -------------------------------------------------------
 // C. load Diffuse Color 1 to MM0 register, unpacked
 // -------------------------------------------------------
 movq      mm0, mm5
 punpcklbw mm0, mm7

 // -------------------------------------------------------
 // D. load Diffuse Color 2 to mm4 register, unpacked
 // -------------------------------------------------------
 movq      mm4, mm5
 psrlq     mm4, 32
 punpcklbw mm4, mm7

 // -------------------------------------------------------
 // c = (h * (b - a)) + a
 // -------------------------------------------------------
 // E. Calculate (mm4 - MM0) * MM3
 // -------------------------------------------------------

 psubw  mm4, mm0
 pmullw mm4, mm3

 // -------------------------------------------------------
 // D. Calculate MM4 + MM0
 // -------------------------------------------------------
 mov   ecx, $00800080
 pxor  mm2, mm2
 movd  mm2, ecx
 movq  mm3, mm2
 psllq mm2, 32
 por   mm2, mm3
 
 psllw mm0, 8
 paddw mm0, mm3
 paddw mm4, mm0
 psrlw mm4, 8



