unit GameTypes;

//---------------------------------------------------------------------------
interface

//---------------------------------------------------------------------------
uses
 SysUtils, Vectors2px, AbstractDevices, AbstractCanvas, AsphyreImages,
 AsphyreFonts, AsphyreDb, AsphyreMatrices, AsphyreScenes, AbstractRasterizer,
 AsphyreLights, AsphyreDirectionalLights;

//---------------------------------------------------------------------------
var
 DisplaySize: TPoint2px;

//---------------------------------------------------------------------------
 GameDevice : TAsphyreDevice = nil;
 GameCanvas : TAsphyreCanvas = nil;
 GameRaster : TAsphyreRasterizer = nil;
 GameImages : TAsphyreImages = nil;
 GameFonts  : TAsphyreFonts  = nil;
 GameScene  : TAsphyreScene = nil;
 MediaASDb  : TASDb = nil;

//---------------------------------------------------------------------------
 fontCandara : Integer = -1;
 fontIceAge  : Integer = -1;

//---------------------------------------------------------------------------
 WorldMtx: TAsphyreMatrix = nil;
 ViewMtx : TAsphyreMatrix = nil;

//---------------------------------------------------------------------------
 LightAmbient      : TAsphyreAmbientLight;
 LightPhong        : TDirectionalPhongLight;
 LightBlinnPhong   : TDirectionalBlinnPhongLight;
 LightMinneart     : TDirectionalMinneartLight;
 LightCookTorrance : TDirectionalCookTorranceLight;
 LightIsotropicWard: TDirectionalIsotropicWardLight;
 LightOrenNayer    : TDirectionalOrenNayerLight;

//---------------------------------------------------------------------------
implementation

//---------------------------------------------------------------------------
initialization
 WorldMtx:= TAsphyreMatrix.Create();
 ViewMtx := TAsphyreMatrix.Create();

//---------------------------------------------------------------------------
finalization
 FreeAndNil(ViewMtx);
 FreeAndNil(WorldMtx);

//---------------------------------------------------------------------------
end.
