unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, SoundSystem, XPMan, StdCtrls, AsphyreDb, ComCtrls, ExtCtrls;

type
  TfrmMain = class(TForm)
    SoundSystem: TSoundSystem;
    btnLoadASDb: TButton;
    ASDb: TASDb;
    btnPlay: TButton;
    btnStop: TButton;
    sbMain: TStatusBar;
    btnFadeIn: TButton;
    btnFadeOut: TButton;
    tbVolume: TTrackBar;
    tbPan: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    tmrMain: TTimer;
    Label3: TLabel;
    edPlayPos: TEdit;
    lbMain: TListBox;
    cbLooped: TCheckBox;
    btnStopAll: TButton;
    lblAktVolume: TLabel;
    lblAktPan: TLabel;
    tbPitch: TTrackBar;
    lblAktPitch: TLabel;
    Label4: TLabel;
    btnReset: TButton;
    procedure FormShow(Sender: TObject);
    procedure cbLoopedClick(Sender: TObject);
    procedure btnResetClick(Sender: TObject);
    procedure tbPitchChange(Sender: TObject);
    procedure btnStopAllClick(Sender: TObject);
    procedure SoundSystemLoad(Sender: TObject; Index: Integer;
      var Name: string);
    procedure tmrMainTimer(Sender: TObject);
    procedure tbPanChange(Sender: TObject);
    procedure tbVolumeChange(Sender: TObject);
    procedure btnFadeOutClick(Sender: TObject);
    procedure btnFadeInClick(Sender: TObject);
    procedure SoundSystemError(Sender: TObject; ErrorText: string);
    procedure btnStopClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnLoadASDbClick(Sender: TObject);
  private

  public

  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.btnLoadASDbClick(Sender: TObject);
begin
  ASDb.FileName := ExtractFilePath(Application.ExeName) + 'Test.ASDb';
  SoundSystem.LoadFromASDb(ASDb);
end;

procedure TfrmMain.btnPlayClick(Sender: TObject);
begin
  SoundSystem.Play(lbMain.ItemIndex, cbLooped.Checked);
end;

procedure TfrmMain.btnStopClick(Sender: TObject);
begin
  SoundSystem.Stop(lbMain.ItemIndex);
end;

procedure TfrmMain.SoundSystemError(Sender: TObject; ErrorText: string);
begin
  sbMain.Panels[2].Text := ErrorText;
end;

procedure TfrmMain.btnFadeInClick(Sender: TObject);
begin
  SoundSystem.FadeIn(lbMain.ItemIndex, 30);
end;

procedure TfrmMain.btnFadeOutClick(Sender: TObject);
begin
  SoundSystem.FadeOut(lbMain.ItemIndex, 30);
end;

procedure TfrmMain.tbVolumeChange(Sender: TObject);
begin
  SoundSystem.SetVolume(lbMain.ItemIndex, tbVolume.Position);
  sbMain.Panels[1].Text := 'Volume: ' + IntToStr(SoundSystem.GetVolume(lbMain.ItemIndex)) + '   Pan: ' + IntToStr(SoundSystem.GetPan(lbMain.ItemIndex)) + '   Pitch: ' + IntToStr(SoundSystem.GetPan(lbMain.ItemIndex));
end;

procedure TfrmMain.tbPanChange(Sender: TObject);
begin
  SoundSystem.SetPan(lbMain.ItemIndex, tbPan.Position);
  sbMain.Panels[1].Text := 'Volume: ' + IntToStr(SoundSystem.GetVolume(lbMain.ItemIndex)) + '   Pan: ' + IntToStr(SoundSystem.GetPan(lbMain.ItemIndex)) + '   Pitch: ' + IntToStr(SoundSystem.GetPan(lbMain.ItemIndex));
end;

procedure TfrmMain.tbPitchChange(Sender: TObject);
begin
  SoundSystem.SetPitch(lbMain.ItemIndex, tbPitch.Position);
  sbMain.Panels[1].Text := 'Volume: ' + IntToStr(SoundSystem.GetVolume(lbMain.ItemIndex)) + '   Pan: ' + IntToStr(SoundSystem.GetPan(lbMain.ItemIndex)) + '   Pitch: ' + IntToStr(SoundSystem.GetPitch(lbMain.ItemIndex));
end;

procedure TfrmMain.tmrMainTimer(Sender: TObject);
begin
  edPlayPos.Text := IntToStr(SoundSystem.GetSoundPos(lbMain.ItemIndex));
  lblAktVolume.Caption := IntToStr(SoundSystem.GetVolume(lbMain.ItemIndex)) + ' %';
  tbVolume.Position := SoundSystem.GetVolume(lbMain.ItemIndex);
  lblAktPan.Caption := IntToStr(SoundSystem.GetPan(lbMain.ItemIndex)) + ' %';
  tbPan.Position := SoundSystem.GetPan(lbMain.ItemIndex);
  lblAktPitch.Caption := IntToStr(SoundSystem.GetPitch(lbMain.ItemIndex));
  tbPitch.Position := SoundSystem.GetPitch(lbMain.ItemIndex);
end;

procedure TfrmMain.SoundSystemLoad(Sender: TObject; Index: Integer; var Name: string);
begin
  sbMain.Panels[2].Text := 'Titles loaded: ' + IntToStr(SoundSystem.Count);
  lbMain.Items.Add(IntToStr(Index) + '  ' + Name);
  lbMain.Selected[0] := True;
end;

procedure TfrmMain.btnStopAllClick(Sender: TObject);
begin
  SoundSystem.StopAll;
end;

procedure TfrmMain.btnResetClick(Sender: TObject);
begin
  SoundSystem.Reset(lbMain.ItemIndex);
end;

procedure TfrmMain.cbLoopedClick(Sender: TObject);
begin
  SoundSystem.SetRepeat(lbMain.ItemIndex, cbLooped.Checked);
end;

procedure TfrmMain.FormShow(Sender: TObject);
begin
  Caption := '   Soundlibrary - DLL  Version: ' + SoundSystem.GetDllVersion;
end;

end.
