unit uMain;

interface

uses
  Windows, SysUtils, Controls, StdCtrls, Classes, Forms, SquallSound, Math,
  Dialogs;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    Label2: TLabel;
    Button3: TButton;
    Button4: TButton;
    procedure FormDestroy(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2MouseEnter(Sender: TObject);
    procedure Button1MouseEnter(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure OnLog(const Text: string);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  ss: TSoundSystem;
  spl: TSoundManager;
  ssmpl1, ssmpl2: TSound;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  //its do nothing if spl isnt playing
  if not spl.IsPlaying then exit;
  ssmpl2.Play(false);
  spl.Position:= SoundVec(Random(Width) - 6, Random(Height - 50) + 44 , 0);
  Label1.Left:= Round(spl.Position[0]);
  Label1.Top:= Round(spl.Position[1]);
end;

procedure TForm1.Button1MouseEnter(Sender: TObject);
begin
  ssmpl1.Play(false);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  ff: Integer;
begin
  {play 2d click sound with "SlowMotion" effect}
  ssmpl2.Frequency:= Trunc(ssmpl2.FileFrequency * 0.4);
  ssmpl2.Play(false);
  ssmpl2.Frequency:= 0;
  {---}
  {set slo-mo frequency to 3d sound}
  ff:= spl.Sample.FileFrequency;
  if (spl.Frequency = ff) or (spl.Frequency = 0) then
    spl.Frequency:= Trunc(ff * 0.4)
  else spl.Frequency:= ff;
end;

procedure TForm1.Button2MouseEnter(Sender: TObject);
begin
  {play 2d OnEnter sound}
  ssmpl1.Frequency:= Trunc(ssmpl1.FileFrequency * 0.4);
  ssmpl1.Play(false);
  ssmpl1.Frequency:= 0;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  spl.StopAll;
  //ss.UnloadGroup(1);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  //creates and plays new channel
  spl.Play(SoundVec(Label1.Left, Label1.Top, 0), true);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ss:= TSoundSystem.Create; //creating of the sound system
  //onlog proc. realy usefull, when you have your own log system
  ss.DoLog:= OnLog;
  {Sound manager is usefull and powerfull when you have multiple instances
  of object, that needs to control sound (for example - weapon.
  you need to set position for each sound made by it weapon. But
  count of it maybe not only one.)}
  spl:= TSoundManager.Create(ss);
  //loads 3d sound, and assign it to the manager
  spl.Sample:= ss.AddSound('fire.wav', st3D, 0);
  spl.Volume:= 100;
  spl.Play(SoundVec(0, 0, 0), true);
  ssmpl1:= ss.AddSound('enter.wav', st2D, 1); //loading OnEnter 2d sound
  ssmpl2:= ss.AddSound('click.wav', st2D, 1); //loading OnClick 2d sound
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  ss.Free; //do it, if you dont want memory leaks!
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  {updates listener position}
  ss.Position:= SoundVec(X, Y, 100);
  //its is neeeded to apply changes
  ss.Update;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  {when form resized, 3d sound will be on it center}
  spl.Position:= SoundVec(Width / 2, Height / 2, 0);
  Label1.Left:= Round(spl.Position[0]);
  Label1.Top:= Round(spl.Position[1]);
end;

procedure TForm1.OnLog(const Text: string);
begin
  {OnLog Proc. You can place here your own worker of system messages}
  //ShowMessage(Text);
end;

initialization
  Randomize;
  ReportMemoryLeaksOnShutdown:= true;

end.
