unit FluxMeshFaces;
//---------------------------------------------------------------------------
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is FluxMeshFaces.pas.
//
// The Initial Developer of the Original Code is M. Sc. Yuriy Kotsarenko.
// Portions created by M. Sc. Yuriy Kotsarenko are Copyright (C) 2007,
// M. Sc. Yuriy Kotsarenko. All Rights Reserved.
//---------------------------------------------------------------------------
interface

//---------------------------------------------------------------------------
uses
 Classes;

//---------------------------------------------------------------------------
type
 PFluxMeshFace = ^TFluxMeshFace;
 TFluxMeshFace = record
  vIndex  : array[0..2] of Integer;
  uvIndex : array[0..2] of Integer;
 end;

//---------------------------------------------------------------------------
 TFluxMeshFaces = class
 private
  Data: array of TFluxMeshFace;

  function GetCount(): Integer;
  function GetItem(Num: Integer): TFluxMeshFace;
  procedure SetItem(Num: Integer; const Value: TFluxMeshFace);
  function GetFace(Num: Integer): PFluxMeshFace;
 public
  property Count: Integer read GetCount;
  property Items[Num: Integer]: TFluxMeshFace read GetItem write SetItem; default;
  property Face[Num: Integer]: PFluxMeshFace read GetFace;

  function Insert(const Face: TFluxMeshFace): Integer; overload;
  function Insert(v0, v1, v2, uv0, uv1, uv2: Integer): Integer; overload;
  function Insert(v0, v1, v2: Integer): Integer; overload;
  procedure Remove(Num: Integer);
  procedure RemoveAll();

  procedure LoadFromStream(Stream: TStream);
  procedure SaveToStream(Stream: TStream);
 end;

//---------------------------------------------------------------------------
implementation

//---------------------------------------------------------------------------
function TFluxMeshFaces.GetCount(): Integer;
begin
 Result:= Length(Data);
end;

//---------------------------------------------------------------------------
function TFluxMeshFaces.GetItem(Num: Integer): TFluxMeshFace;
begin
 Assert((Num >= 0)and(Num < Length(Data)),
  'TFluxMeshFaces.GetItem: Num out of bounds');

 Result:= Data[Num];
end;

//---------------------------------------------------------------------------
procedure TFluxMeshFaces.SetItem(Num: Integer; const Value: TFluxMeshFace);
begin
 Assert((Num >= 0)and(Num < Length(Data)),
  'TFluxMeshFaces.SetItem: Num out of bounds');

 Data[Num]:= Value;
end;

//---------------------------------------------------------------------------
function TFluxMeshFaces.GetFace(Num: Integer): PFluxMeshFace;
begin
 Assert((Num >= 0)and(Num < Length(Data)),
  'TFluxMeshFaces.GetFace: Num out of bounds');

 Result:= @Data[Num];
end;

//---------------------------------------------------------------------------
function TFluxMeshFaces.Insert(const Face: TFluxMeshFace): Integer;
var
 Index: Integer;
begin
 Index:= Length(Data);
 SetLength(Data, Index + 1);

 Data[Index]:= Face;
 Result:= Index;
end;

//---------------------------------------------------------------------------
function TFluxMeshFaces.Insert(v0, v1, v2, uv0, uv1, uv2: Integer): Integer;
var
 Tri: TFluxMeshFace;
begin
 Tri.vIndex[0] := v0;
 Tri.vIndex[1] := v1;
 Tri.vIndex[2] := v2;
 Tri.uvIndex[0]:= uv0;
 Tri.uvIndex[1]:= uv1;
 Tri.uvIndex[2]:= uv2;

 Result:= Insert(Tri);
end;

//---------------------------------------------------------------------------
function TFluxMeshFaces.Insert(v0, v1, v2: Integer): Integer;
begin
 Result:= Insert(v0, v1, v2, v0, v1, v2);
end;

//---------------------------------------------------------------------------
procedure TFluxMeshFaces.Remove(Num: Integer);
var
 i: Integer;
begin
 Assert((Num >= 0)and(Num < Length(Data)),
  'TFluxMeshFaces.Remove: Num out of bounds');

 for i:= Num to Length(Data) - 2 do
  Data[i]:= Data[i + 1];

 SetLength(Data, Length(Data) - 1);
end;

//---------------------------------------------------------------------------
procedure TFluxMeshFaces.RemoveAll();
begin
 SetLength(Data, 0);
end;

//--------------------------------------------------------------------------
procedure TFluxMeshFaces.SaveToStream(Stream: TStream);
var
 i, Count: Integer;
begin
 Count:= Length(Data);
 Stream.WriteBuffer(Count, SizeOf(Integer));

 for i:= 0 to Count - 1 do
  Stream.WriteBuffer(Data[i], SizeOf(TFluxMeshFace));
end;

//--------------------------------------------------------------------------
procedure TFluxMeshFaces.LoadFromStream(Stream: TStream);
var
 i, Count: Integer;
begin
 Stream.ReadBuffer(Count, SizeOf(Integer));

 SetLength(Data, Count);
 for i:= 0 to Count - 1 do
  Stream.ReadBuffer(Data[i], SizeOf(TFluxMeshFace));
end;

//---------------------------------------------------------------------------
end.
