unit TexClipper2;

//---------------------------------------------------------------------------
interface

//---------------------------------------------------------------------------
uses
 Vectors2, Vectors3, SystemSurfaces;

//---------------------------------------------------------------------------
procedure TexMapAffine(Dest, Texture: TSystemSurface;
 const v0, v1, v2: TVector3;
 const uv0, uv1, uv2: TPoint2);
procedure TexMapPerspective(Dest, Texture: TSystemSurface;
 const v0, v1, v2: TVector3;
 const uv0, uv1, uv2: TPoint2);

//---------------------------------------------------------------------------
implementation

//---------------------------------------------------------------------------
uses
 SuHoClipAffine, SuHoClipPerspective, TexMapChHe, TxtArb2;

//---------------------------------------------------------------------------
var
 ClipArray: array[0..31] of TClipItem;

//---------------------------------------------------------------------------
procedure TexMapAffine(Dest, Texture: TSystemSurface;
 const v0, v1, v2: TVector3;
 const uv0, uv1, uv2: TPoint2);
var
 i, Base, Count, OutCount: Integer;
 Item0, Item1, Item2: PClipItem;
begin
 ClipArray[0].Position:= v0;
 ClipArray[0].TexCoord:= uv0;
 ClipArray[1].Position:= v1;
 ClipArray[1].TexCoord:= uv1;
 ClipArray[2].Position:= v2;
 ClipArray[2].TexCoord:= uv2;

 Base := 0;
 Count:= 3;
 SuHoClipAffine.ClipLeft(@ClipArray[Base], @ClipArray[Base + Count],
  Count, OutCount);

 Inc(Base, Count);
 Count:= OutCount;
 SuHoClipAffine.ClipRight(@ClipArray[Base], @ClipArray[Base + Count],
  Count, OutCount);

 Inc(Base, Count);
 Count:= OutCount;
 SuHoClipAffine.ClipTop(@ClipArray[Base], @ClipArray[Base + Count],
  Count, OutCount);

 Inc(Base, Count);
 Count:= OutCount;
 SuHoClipAffine.ClipBottom(@ClipArray[Base], @ClipArray[Base + Count],
  Count, OutCount);

 Inc(Base, Count);
 Count:= OutCount;

 for i:= 0 to Count - 3 do
  begin
   Item0:= @ClipArray[Base];
   Item1:= @ClipArray[Base + 1 + i];
   Item2:= @ClipArray[Base + 2 + i];

   TxtArb2.TexMap(Dest, Texture, Item2.Position, Item1.Position,
    Item0.Position, Item2.TexCoord, Item1.TexCoord, Item0.TexCoord);
  end;
end;

//---------------------------------------------------------------------------
procedure TexMapPerspective(Dest, Texture: TSystemSurface;
 const v0, v1, v2: TVector3;
 const uv0, uv1, uv2: TPoint2);
var
 i, Base, Count, OutCount: Integer;
 Item0, Item1, Item2: PClipItem;
begin
 ClipArray[0].Position:= v0;
 ClipArray[0].TexCoord:= uv0;
 ClipArray[1].Position:= v1;
 ClipArray[1].TexCoord:= uv1;
 ClipArray[2].Position:= v2;
 ClipArray[2].TexCoord:= uv2;

 Base := 0;
 Count:= 3;
 SuHoClipPerspective.ClipLeft(@ClipArray[Base], @ClipArray[Base + Count],
  Count, OutCount);

 Inc(Base, Count);
 Count:= OutCount;
 SuHoClipPerspective.ClipRight(@ClipArray[Base], @ClipArray[Base + Count],
  Count, OutCount);

 Inc(Base, Count);
 Count:= OutCount;
 SuHoClipPerspective.ClipTop(@ClipArray[Base], @ClipArray[Base + Count],
  Count, OutCount);

 Inc(Base, Count);
 Count:= OutCount;
 SuHoClipPerspective.ClipBottom(@ClipArray[Base], @ClipArray[Base + Count],
  Count, OutCount);

 Inc(Base, Count);
 Count:= OutCount;

 for i:= 0 to Count - 3 do
  begin
   Item0:= @ClipArray[Base];
   Item1:= @ClipArray[Base + 1 + i];
   Item2:= @ClipArray[Base + 2 + i];

   TexMapChHe.TexMap(Dest, Texture, Item2.Position, Item1.Position,
    Item0.Position, Item2.TexCoord, Item1.TexCoord, Item0.TexCoord);
  end;
end;

//---------------------------------------------------------------------------
end.
