unit SoundChannel;

interface

uses
  Windows, SysUtils, Classes, Bass, SoundDevice;

type
  TSoundChannel = class(TComponent)
  private
    { Private declarations }

  spfilename:string;
  audiovolume:Integer;
  Channel:DWORD;

  protected
    { Protected declarations }
  public
    { Public declarations }

  constructor create(AOwner : TComponent); override;

  procedure Play;
  procedure Stop;
  procedure Pause;
  procedure Load;

  function ChangeFilename :string;
  function ChangeVolume :integer;

  procedure LoadAudioVolume;

  published
    { Published declarations }
  property Filename : string read ChangeFilename write spfilename;
  property ChannelVolume : integer read ChangeVolume write audiovolume;

  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('ZXLib', [TSoundChannel]);
end;

function TSoundChannel.ChangeFilename:string;
begin
result := spfilename;
end;

function TSoundChannel.ChangeVolume:integer;
begin
result := AudioVolume;
end;

procedure TSoundChannel.LoadAudioVolume;
begin

Bass_ChannelSetAttributes(Channel, 0, AudioVolume, 0);

end;

constructor TSoundChannel.Create(AOwner : TComponent);
begin
inherited create(AOwner);


end;

procedure TSoundChannel.Load;
begin

Channel := BASS_StreamCreateFile(FALSE, PChar(spfilename), 0, 0, 0);

end;


procedure TSoundChannel.Play;
begin
BASS_ChannelPlay(Channel, False);
end;

procedure TSoundChannel.Stop;
begin
BASS_ChannelStop(Channel);
end;

procedure TSoundChannel.Pause;
begin
BASS_ChannelPause(Channel);
end;

end.
