unit SoundDevice;

interface

uses
  Windows, SysUtils, Classes, Bass;

type
  TSoundDevice = class(TComponent)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }

  procedure InitializeDevice;
  procedure FinalizeDevice;

  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('ZXLib', [TSoundDevice]);
end;

procedure TSoundDevice.InitializeDevice;
begin

if BASS_GetVersion() <> DWORD(MAKELONG(2,2)) then begin
MessageBox(0,'BASS version 2.2 was not loaded!', 'Error!', MB_OK + MB_ICONERROR);
Halt;
end;

if not BASS_Init(-1, 44100, 0, 0, nil) then
begin
MessageBox(0,'Error initializing audio!', 'Error!', MB_OK + MB_ICONERROR);
end;

//end initialize
end;

procedure TSoundDevice.FinalizeDevice;
begin

Bass_Free;

end;

end.
